$ENGINE=VBScript
'**************************************************************** 
'* RelativeDisp.vbs                                                  *
'* Created 25th February 2014                                   *
'* Calculate displacements of all nodes relative to a 			*
'* predefined  node in mesh for a range of loadcases			*
'****************************************************************
'* THIS SCRIPT IS NOT PART OF LUSAS SOFTWARE AND AS SUCH IS     *
'* NOT QUALITY APPROVED OR SUPPORTED IT IS PROVIDED ON AN AS    *
'* IS BASIS FOR DEMONSTRATION PURPOSES.                         *
'****************************************************************
'
'
' Ask user to enter reference node number
NodeID = InputBox("Enter reference node number")

' Ask user to enter Loadcases to consider
FirstLC = InputBox("Enter ID of first loadcase to consider","First Loadcase")
LastLC = InputBox("Enter ID of last loadcase to consider","Last Loadcase")


' Extract array of nodes in model
nodes = database.getObjects("Nodes")

' Indicate the size of the arrays which are used in this script
nNodes = UBound(nodes)
nStructLC = LastLC


' Displacement arrays are of size (No of loadcases, No of nodes)
redim DX(nStructLC, nNodes)
redim DY(nStructLC, nNodes)
redim DZ(nStructLC, nNodes)
redim THX(nStructLC, nNodes)
redim THY(nStructLC, nNodes)
redim THZ(nStructLC, nNodes)


' Array containing node IDs
redim NodeIDs(nNodes)


' Loop over nodes to get their IDs
For n = 0 to nNodes
	NodeIDs(n) = nodes(n).getID()
next


' Flush results column
database.flushScriptedResults()


' Loop over loadcases
For i = FirstLC to LastLC
	' Loop over nodes
	For n = 0 to nNodes
	' Store results for this node in this loadcase
		DX(i,n) = nodes(n).getResults("Displacement", "DX")
		DY(i,n) = nodes(n).getResults("Displacement", "DY")
		DZ(i,n) = nodes(n).getResults("Displacement", "DZ")
		THX(i,n) = nodes(n).getResults("Displacement", "THX")
		THY(i,n) = nodes(n).getResults("Displacement", "THY")
		THZ(i,n) = nodes(n).getResults("Displacement", "THZ")
	next
next


' Arrays for the dispacements of reference node
redim RefDX(nStructLC)
redim RefDY(nStructLC)
redim RefDZ(nStructLC)
redim RefTHX(nStructLC)
redim RefTHY(nStructLC)
redim RefTHZ(nStructLC)


set relnode = db.getObject("Node", NodeID)
' Loop over loadcases
For i = FirstLC to LastLC
	' Store results for reference node
	RefDX(i) = relnode.getResults("Displacement", "DX")
	RefDY(i) = relnode.getResults("Displacement", "DY")
	RefDZ(i) = relnode.getResults("Displacement", "DZ")
	RefTHX(i) = relnode.getResults("Displacement", "THX")
	RefTHY(i) = relnode.getResults("Displacement", "THY")
	RefTHZ(i) = relnode.getResults("Displacement", "THZ")		
next


' Relative displacement arrays are of size (No of loadcases, No of nodes)
redim RelDX(nStructLC,nNodes)
redim RelDY(nStructLC,nNodes)
redim RelDZ(nStructLC,nNodes)
redim RelTHX(nStructLC,nNodes)
redim RelTHY(nStructLC,nNodes)
redim RelTHZ(nStructLC,nNodes)

' Loop over loadcases
For i = FirstLC to LastLC
	' Write current lodacasr number in Text Output Window
	textwin.writeline("Results for LC = "& i)
	textwin.writeline("===============================================================")
	'Loop over nodes
	For n = 0 to nNodes
		' Write current lodacasr number in Text Output Window
		textwin.writeline("Node = "& NodeIDs(n))
		' Store results for this node in this loadcase
		RelDX(i,n) = RefDX(i) - DX(i,n)
		RelDY(i,n) = RefDY(i) - DY(i,n)
		RelDZ(i,n) = RefDZ(i) - DZ(i,n)
		RelTHX(i,n) = RefTHX(i) - THX(i,n)
		RelTHY(i,n) = RefTHY(i) - THY(i,n)
		RelTHZ(i,n) = RefTHZ(i) - THZ(i,n)
		' Write results in Text Output Window
		textwin.writeline("RelDX = "& RelDX(i,n))
		textwin.writeline("RelDY = "& RelDY(i,n))
		textwin.writeline("RelDZ = "& RelDZ(i,n))
		textwin.writeline("RelTHX = "& RelTHX(i,n))
		textwin.writeline("RelTHY = "& RelTHY(i,n))
		textwin.writeline("RelTHZ = "& RelTHZ(i,n))
		textwin.writeline("===============================================================")
	next
next







